/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.wizards;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ProcessStatus;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.github.IGithubManager;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.ui.CloneJob;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.wizards.GithubRepositorySelectionPage;
import com.aptana.git.ui.internal.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class GithubForkWizard
extends Wizard
implements IImportWizard {
    private GithubRepositorySelectionPage cloneSource;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.cloneSource = new GithubRepositorySelectionPage();
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.cloneSource);
    }

    public boolean performFinish() {
        final IGithubManager ghManager = GitPlugin.getDefault().getGithubManager();
        final String owner = this.cloneSource.getOwner();
        final String repoName = this.cloneSource.getRepoName();
        final String organization = null;
        final String dest = this.cloneSource.getDestination();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.subTask(Messages.GithubForkWizard_ForkSubTaskName);
                        IGithubRepository repo = ghManager.fork(owner, repoName, organization);
                        CloneJob job = new CloneJob(repo.getSSHURL(), dest);
                        IStatus status = job.run(monitor);
                        if (!status.isOK()) {
                            if (status instanceof ProcessStatus) {
                                ProcessStatus ps = (ProcessStatus)status;
                                String stderr = ps.getStdErr();
                                throw new InvocationTargetException(new CoreException((IStatus)new Status(status.getSeverity(), status.getPlugin(), stderr)));
                            }
                            throw new InvocationTargetException(new CoreException(status));
                        }
                        Set<IProject> projects = job.getCreatedProjects();
                        if (!CollectionsUtil.isEmpty(projects)) {
                            monitor.subTask(Messages.GithubForkWizard_UpstreamSubTaskName);
                            IProject project = projects.iterator().next();
                            IGitRepositoryManager grManager = GitPlugin.getDefault().getGitRepositoryManager();
                            GitRepository clonedRepo = grManager.getAttached(project);
                            if (clonedRepo != null) {
                                IGithubRepository parentRepo = repo.getParent();
                                clonedRepo.addRemote("upstream", parentRepo.getSSHURL(), false);
                            }
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                CoreException ce = (CoreException)e.getCause();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.GithubForkWizard_FailedForkErr, (String)ce.getMessage());
            } else {
                IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            }
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
        }
        return true;
    }
}

